#ifndef nanoTronic065.h
#define nanoTronic065.h

int ip[10] = {0, A7,A6,8,7,  A3,A2,A1,A0,13}; // Arduino pins, default
int i[10] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
int r[10] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
int f[10] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
int i1 = 0, i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0;
int r1 = 0, r2 = 0, r3 = 0, r4 = 0, r5 = 0, r6 = 0, r7 = 0, r8 = 0, r9 = 0;
int f1 = 0, f2 = 0, f3 = 0, f4 = 0, f5 = 0, f6 = 0, f7 = 0, f8 = 0, f9 = 0;

unsigned long ms[5] = {0, 0, 0, 0, 0};
int c[5] = {0, 0, 0, 0, 0};

int op[10] = {0, 12,11,10,9,  6,5,4,3,2}; // Arduino pins, default
int o[10] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
int oe[10] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
int o1 = 0, o2 = 0, o3 = 0, o4 = 0, o5 = 0, o6 = 0, o7 = 0, o8 = 0, o9 = 0;

int deBounceMs = 50;
unsigned long dBt[10] = {0,0,0,0,0, 0,0,0,0,0};
                  
bool fHistCheck(int a){
  if (dBt[a] < millis()){    
    return false;
  } else {
    return true;
  }
}

void fHistorySave(int a){
   dBt[a] = millis() + deBounceMs; 
}

String outp = "", iOut = "", oOut = "";

void setPinM(){ // set Pin Modes
    // Configure pin numbers differently
    int pinConfig = 0; // 0 - default, 1 - legacy
    if (pinConfig){
        ip[1] = 14; ip[2] = 13; ip[3] = 17; ip[4] = 10; // GPIO number, legacy
	ip[5] = 20; ip[6] = 3; ip[7] = 2; ip[8] = 1; ip[9] = 48; 
        op[1] = 47; op[2] = 38; op[3] = 21; op[4] = 18;
        op[5] = 9; op[6] = 8; op[7] = 7; op[8] = 6; op[9] = 5; 
	pinMode(ip[5], INPUT);
    }
    pinMode(ip[5], INPUT);
    for (int a = 1; a < 10; a++) {
        pinMode(op[a], OUTPUT);
        digitalWrite(op[a], LOW);
    }
}

void stOne(){
  setPinM();
  Serial.begin(115200);
} // end 


bool timePass(int timeIn = 1){
    if (ms[timeIn] > 0 && millis() > ms[timeIn]){
	ms[timeIn] = 0; 
        return true;
    } else {
        return false;
    }
} // end timePass func


void timeStart(int millisIn, int timeIn = 1){
    ms[timeIn] = millis() + millisIn;
} // end timeStart func


void countStart(int htimes, int cIn = 1){
    c[cIn] = htimes;
} // end count

bool countEnded(int cIn = 1){
    if (!c[cIn]){
        return true;
    } else {
	c[cIn]--;
        return false;
    }
} // end cEnded


void inRe(){ //////// input Reading set i variables ///////
    iOut = "";
    for (int a = 1; a < 3; a++) {
        if (analogRead(ip[a]) > 600){ 
	    if (i[a] == 0 & !fHistCheck(a)){ 
	        r[a] = 1; 
            } else { 
                r[a] = 0; 
            } 
            i[a] = 1; f[a] = 0;
        } else if (analogRead(ip[a]) < 400){ 
            if (i[a] == 1){ 
                f[a] = 1; 
		fHistorySave(a); 
            } else { 
                f[a] = 0; 
            } 
            i[a] = 0; r[a] = 0; 
         }
         iOut.concat(i[a]);        
    } // end for loop  

    for (int a = 3; a < 10; a++) {
        if (digitalRead(ip[a]) == HIGH){ 
	    if (i[a] == 0 & !fHistCheck(a)){ 
	        r[a] = 1; 
            } else { 
                r[a] = 0; 
            } 
            i[a] = 1; f[a] = 0;
        } else if (digitalRead(ip[a]) == LOW){ 
            if (i[a] == 1){ 
                f[a] = 1; 
		fHistorySave(a); 
            } else { 
                f[a] = 0; 
            } 
            i[a] = 0; r[a] = 0; 
        }
	if (a == 5){
            iOut.concat(" ");
	}
         iOut.concat(i[a]);        
    } // end for loop  
    iOut.concat(" i");
    i1 = i[1]; i2 = i[2]; i3 = i[3]; i4 = i[4]; i5 = i[5]; i6 = i[6]; i7 = i[7]; i8 = i[8]; i9 = i[9];
    r1 = r[1]; r2 = r[2]; r3 = r[3]; r4 = r[4]; r5 = r[5]; r6 = r[6]; r7 = r[7]; r8 = r[8]; r9 = r[9];
    f1 = f[1]; f2 = f[2]; f3 = f[3]; f4 = f[4]; f5 = f[5]; f6 = f[6]; f7 = f[7]; f8 = f[8]; f9 = f[9];
} // end inMo


String str(int inputInt){
    return String(inputInt);
}


void print(String inExtraText = "", String inExtraText2 = "", String inExtraText3 = "", String inExtraText4 = "", String inExtraText5 = ""){  
  outp = ""; 
  outp.concat(inExtraText); 
  outp.concat(inExtraText2); 
  outp.concat(inExtraText3); 
  outp.concat(inExtraText4); 
  outp.concat(inExtraText5); 
  Serial.println(outp); 
}

void pio(){
  Serial.println(iOut); 
  Serial.println(oOut); 
}

String sm = "";

void seRe(){
   if (Serial.available()){
    char incomingChar = Serial.read();
    if (incomingChar != '\n'){
      sm += String(incomingChar);
    } else {
      if (sm == "op"){
          print(oOut);
      }

      if (sm == "ip"){
         print(iOut);
      }
      if (sm == "p"){
         pio();
      }
      sm = "";
    }
  }
} // end seRe



int cOp(int eelm, int oarr, int ovb){ // compare outputs
    if (oarr == eelm && ovb != eelm){
        return(ovb);
    } else {
	return(oarr); 
    }
} // end cOp


void doOut(){
    oOut = "";
    o[1] = cOp(oe[1], o[1], o1); o[2] = cOp(oe[2], o[2], o2); o[3] = cOp(oe[3], o[3], o3); o[4] = cOp(oe[4], o[4], o4);
    o[5] = cOp(oe[5], o[5], o5); o[6] = cOp(oe[6], o[6], o6); o[7] = cOp(oe[7], o[7], o7); o[8] = cOp(oe[8], o[8], o8); 
    o[9] = cOp(oe[9], o[9], o9);
    for (int a = 1; a < 10; a++) {
        oe[a] = o[a];
        if (o[a] == 1){ 
	    digitalWrite(op[a], HIGH); 
        } else if (o[a] == 0) { 
            digitalWrite(op[a], LOW); 
        }
	if (a == 5){
            oOut.concat(" ");
	}
        oOut.concat(o[a]);
    } // end for loop
    o1 = o[1]; o2 = o[2]; o3 = o[3]; o4 = o[4]; o5 = o[5]; o6 = o[6]; o7 = o[7]; o8 = o[8]; o9 = o[9];
    oOut.concat(" o"); 
} // end doOut


#endif